﻿<# Zapisuje status usług Windows w arkuszu Excel #>

# Tworzy obiekt klasy Excel.Application
$Excel = New-Object -comobject Excel.Application 

# Sprawia, że egzemplarz ten staje się widoczny
$Excel.visible = $True

# Tworzy skoroszyt programu Excel
$ExcelWB = $Excel.Workbooks.Add() 

# Tworzy jeden arkusz kalkulacyjny Excel
$ExcelWS = $ExcelWB.Worksheets.Item(1) 

# Definiuje tytuł raportu
$ExcelWS.Cells.Item(1,1) = "Raport o stanie usług"
$ExcelWS.Range("A1","B1").Cells.Merge()

# Tworzy nagłówek tabeli
# Nazwa i szerokość pierwszej kolumny tabeli
$ExcelWS.Cells.Item(2,1) = "Nazwa usługi"
$ExcelWS.Cells.Item(2,1).ColumnWidth = 30 

# Nazwa i szerokość drugiej kolumny tabeli
$ExcelWS.Cells.Item(2,2) = "Status usługi" 
$ExcelWS.Cells.Item(2,2).ColumnWidth = 15

# Tło komórki, czcionka i grubość nagłówka
$ExcelWS.Range("A2","B2").Interior.ColorIndex = 41 
$ExcelWS.Range("A2","B2").Font.ColorIndex = 2 
$ExcelWS.Range("A2","B2").Font.Bold = $True 


$row = 3

ForEach($Service in Get-Service)
{
    # Wstawia informacje o usługach do wierszy
    $ExcelWS.Cells.Item($row,1) = $Service.DisplayName
    $ExcelWS.Cells.Item($row,2) = $Service.Status.ToString()

    
    # Zmienia kolor czcionki na zielony lub czerwony, zależnie od statusu usługi
    if($Service.Status -eq "Running")
        {
            $ExcelWS.Cells.Item($row,1).Font.ColorIndex = 10
            $ExcelWS.Cells.Item($row,2).Font.ColorIndex = 10
        }
    Elseif($Service.Status -eq "Stopped")
        {
            $ExcelWS.Cells.Item($row,1).Font.ColorIndex = 3
            $ExcelWS.Cells.Item($row,2).Font.ColorIndex = 3
        }
        

  $row++  
}

# Autodopasowywanie kolumn tabeli
$ExcelWS.UsedRange.EntireColumn.AutoFit()

# Zapisuje arkusz
$ExcelWS.SaveAs("D:\ServicesStatusReport.xlsx")

# Zamyka Excel
$Excel.Quit()            